import os


output = open("script.sh", 'w')
directory = "."
filenames = os.listdir(directory)
for filename in sorted(filenames):
    library, extension = os.path.splitext(filename)
    if extension != ".fq":
        continue
    condition, replicate = library.split("_")
    assert replicate in ("r1", "r2", "r3")
    script_name = "script_%s.sh" % library
    handle = open(script_name, 'w')
    handle.write("""\
#!/bin/bash
#SBATCH -e ./script_%s.stderr
#SBATCH -o ./script_%s.stdout
#SBATCH --mem=4G
python make_sequence_index.py %s
""" % (library, library, library))
    handle.close()
    output.write('sbatch %s\n' % script_name)

output.close()
print("Scripts generated; run script.sh to schedule them on Grid Engine")
